@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')
<style>
    .quotation-sidebar {
        position: fixed;
        top: 0;
        right: -500px;
        width: 450px;
        height: 100%;
        background: #fff;
        box-shadow: -2px 0 8px rgba(0, 0, 0, 0.2);
        transition: 0.3s ease;
        z-index: 9999;
        overflow-y: auto;
    }

    .quotation-sidebar.active {
        right: 0;
    }
</style>
<div class="page-content">
    <div class="container-xxl">

        {{-- ================= PROJECT HEADER ================= --}}
        <div class="card mb-4 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">

                    {{-- LEFT SIDE --}}
                    <div>
                        <h3 class="mb-2">
                            {{ $project->project_name }}
                            <span class="badge bg-info ms-2">
                                {{ $project->project_number }}
                            </span>
                        </h3>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Customer :</strong>
                                    {{ $project->customer_name }}
                                </p>
                                <p class="mb-1">
                                    <strong>Phone :</strong>
                                    {{ $project->customer_phone }}
                                </p>
                                <p class="mb-1">
                                    <strong>Address :</strong>
                                    {{ $project->address }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Project Type :</strong>
                                    {{ $project->project_type ?? '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Expected Completion :</strong>
                                    {{ $project->expected_completion_date 
                                ? \Carbon\Carbon::parse($project->expected_completion_date)->format('d M Y') 
                                : '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Status :</strong>
                                    <span class="badge 
                                @if($project->status == 'completed') bg-success
                                @elseif($project->status == 'pending') bg-warning
                                @else bg-secondary
                                @endif">
                                        {{ ucfirst($project->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>

                    {{-- RIGHT SIDE --}}
                    <div class="text-end">

                        <p class="mb-1">
                            <strong>Employee :</strong>
                            {{ $project->employee_name ?? '-' }}
                        </p>

                        <p class="mb-3">
                            <strong>Contact :</strong>
                            {{ $project->employee_contact ?? '-' }}
                        </p>

                        {{-- PDF Buttons --}}
                        <div class="d-flex justify-content-end align-items-center gap-2 flex-wrap">

                            {{-- Upload / Update --}}
                            <button class="btn btn-dark btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#quotationModal">
                                <i class="bi bi-upload"></i>
                                {{ $project->quotation_pdf ? 'Update Quotation' : 'Upload Quotation' }}
                            </button>

                            {{-- View Quotation (if exists) --}}
                            @if($project->quotation_pdf)
                            <a href="{{ asset($project->quotation_pdf) }}"
                                target="_blank"
                                class="btn btn-success btn-sm px-3">
                                <i class="bi bi-eye"></i> View
                            </a>
                            @endif

                            <button class="btn btn-info btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#totalamountnModal">
                                <i class="bi bi-upload"></i>
                                {{ $project->total_amount==0 ? 'Add Total Amount' : 'Update Total Amount' }}
                            </button>

                            {{-- More Actions Dropdown --}}
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary btn-sm dropdown-toggle"
                                    data-bs-toggle="dropdown">
                                    More PDFs
                                </button>

                                <ul class="dropdown-menu dropdown-menu-end shadow">
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/measurement/'.$project->id) }}"
                                            target="_blank">
                                            Measurement PDF
                                        </a>
                                    </li>

                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/invoice/'.$project->id) }}"
                                            target="_blank">
                                            Invoice PDF
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/quotation/'.$project->id) }}"
                                            target="_blank">
                                            Client Quotation
                                        </a>
                                    </li>
                                </ul>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Subtotal</h6>
                        <h4 class="text-primary">
                            ₹ {{ number_format($project->subtotal, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>GST (18%)</h6>
                        <h4 class="text-warning">
                            ₹ {{ number_format($project->tax, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Grand Total</h6>
                        <h4 class="text-success">
                            ₹ {{ number_format($project->grand_total, 2) }}
                        </h4>
                    </div>
                </div>
            </div>
        </div>

        {{-- ================= PROJECT SUMMARY ================= --}}
        <div class="row mb-2">
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Areas</h5>
                        <h3>{{ $project->areas->count() }}</h3>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Items</h5>
                        <h3>
                            {{ $project->areas->sum(fn($area) => $area->items->count()) }}
                        </h3>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h5>Total Amount Entered</h5>
                        <h6> {{ $project->total_amount }}</h6>
                    </div>
                </div>
            </div>
        </div>



        {{-- ================= AREAS LOOP ================= --}}
        @foreach($project->areas as $area)

        <div class="card mb-4">
            <div class="card-header bg-light">
                <h5 class="mb-0">
                    Area: {{ $area->name }}
                    @if($area->room)
                    <span class="text-muted">
                        (Room: {{ $area->room->name }})
                    </span>
                    @endif
                </h5>
            </div>

            <div class="card-body">

                @if($area->items->count() > 0)

                <div class="table-responsive">
                    <table class="table table-bordered align-middle table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="4%">#</th>
                                <th width="8%">Image</th>
                                <th width="12%">Product</th>
                                <th width="8%">Type</th>
                                <th width="8%">Unit</th>
                                <th width="8%">Qty</th>
                                <th width="12%">Size</th>
                                <th width="12%">Room</th>
                                <th width="10%">Item</th>
                                <th width="12%">Catalog</th>
                                <th width="10%">Serial</th>
                                <th>Description</th>
                                <th>Add to Quotation</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach($area->items as $index => $item)

                            @php
                            $unit = 'Nos';
                            $qty = 1;

                            // ===============================
                            // NON CUSTOM
                            // ===============================
                            if($item->is_custom == 0){

                            $qty = (float) ($item->quantity ?? 1);

                            if($item->category == 'curtain'){
                            $unit = 'Pcs';
                            }
                            elseif($item->category == 'wallpaper'){
                            $unit = 'Rolls';
                            }

                            }
                            // ===============================
                            // CUSTOM CURTAIN
                            // ===============================
                            elseif($item->category == 'curtain' && $item->curtain && $item->measurement){

                            $fw = (float) $item->curtain->fabric_width;
                            $ww = (float) $item->measurement->width;
                            $wh = (float) $item->measurement->height;

                            if($fw > 0){
                            $panels = ceil($ww / $fw);
                            $qty = $panels * $wh;
                            }

                            $unit = 'Meter';
                            }
                            // ===============================
                            // CUSTOM WALLPAPER
                            // ===============================
                            elseif($item->category == 'wallpaper' && $item->wallpaper){

                            $rw = (float) $item->wallpaper->roll_width;
                            $rl = (float) $item->wallpaper->roll_length;
                            $ww = (float) $item->wallpaper->wall_width;
                            $wh = (float) $item->wallpaper->wall_height;
                            $rep = (float) ($item->wallpaper->design_repeat ?? 0);

                            if($rw > 0 && $rl > 0){
                            $cuttings = ceil($ww / $rw);
                            $totalLength = $cuttings * ($wh + $rep);
                            $qty = ceil($totalLength / $rl);
                            }

                            $unit = 'Rolls';
                            }
                            @endphp

                            <tr>

                                {{-- SL --}}
                                <td>{{ $index + 1 }}</td>

                                {{-- IMAGE --}}
                                <td>
                                    @if($item->is_custom == 0 && $item->variant?->primaryImage?->image_path)
                                    <img src="{{ asset($item->variant->primaryImage->image_path) }}" width="60">
                                    @else
                                    <span class="text-muted">Custom</span>
                                    @endif
                                </td>

                                {{-- PRODUCT --}}
                                <td>
                                    {{ $item->product->name ?? 'Custom Item' }}
                                </td>

                                {{-- TYPE (is_custom badge) --}}
                                <td>
                                    @if($item->is_custom == 1)
                                    <span class="badge bg-warning text-dark">Custom</span>
                                    @else
                                    <span class="badge bg-success">Standard</span>
                                    @endif
                                </td>

                                {{-- UNIT --}}
                                <td>{{ $unit }}</td>

                                {{-- QTY --}}
                                <td>{{ $qty > 0 ? number_format($qty,2) : '-' }}</td>

                                {{-- SIZE --}}
                                <td>
                                    @if($item->measurement)
                                    {{ $item->measurement->width ?? '-' }}
                                    x
                                    {{ $item->measurement->height ?? '-' }}
                                    {{ $item->measurement->unit ?? '' }}
                                    @else
                                    -
                                    @endif
                                </td>

                                {{-- ROOM --}}
                                <td>{{ $area->area_name ?? $area->name ?? '-' }}</td>

                                {{-- CATEGORY --}}
                                <td>{{ ucfirst($item->category ?? '-') }}</td>

                                {{-- CATALOG --}}
                                <td>
                                    {{
            $item->curtain->catalogue ??
            $item->wallpaper->catalogue ??
            '-'
        }}
                                </td>

                                {{-- SERIAL --}}
                                <td>
                                    {{
            $item->curtain->serial_no ??
            $item->wallpaper->serial_no ??
            '-'
        }}
                                </td>

                                {{-- DESCRIPTION --}}
                                <td>{{ $item->notes ?? '-' }}</td>

                                <td>
                                    <button class="btn btn-sm btn-primary"
                                        onclick='openQuotationSidebar(@json($item))'>
                                        Add To Quotation
                                    </button>
                                </td>
                            </tr>

                            @endforeach

                        </tbody>
                    </table>
                </div>


                @else
                <p class="text-muted">No items found in this area.</p>
                @endif

            </div>
        </div>

        @endforeach


        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

<!-- Quotation Upload Modal -->
<div class="modal fade" id="quotationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <form action="{{ route('projects.upload.quotation', $project->id) }}"
                method="POST"
                enctype="multipart/form-data">

                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }} Quotation PDF
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="mb-3">
                        <label class="form-label">Select PDF File</label>
                        <input type="file"
                            name="quotation_pdf"
                            class="form-control"
                            accept="application/pdf"
                            required>
                        <small class="text-muted">
                            Max size: 4MB
                        </small>
                    </div>

                    @if($project->quotation_pdf)
                    <p>
                        Current File:
                        <a href="{{ asset($project->quotation_pdf) }}"
                            target="_blank">
                            View PDF
                        </a>
                    </p>
                    @endif

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }}
                    </button>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>

<!-- update total amount Modal -->
<div class="modal fade" id="totalamountnModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <form action="{{ route('projects-uptate-total', $project->id) }}"
                method="POST"
                enctype="multipart/form-data">

                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }} Quotation PDF
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="project_id" value="{{$project->id}}">
                    <div class="mb-3">
                        <label class="form-label">Enter total</label>
                        <input type="number" step="0.1"
                            name="total_amount"
                            class="form-control"
                            required>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        {{ $project->total_amount==0 ? 'Add' : 'Update' }}
                    </button>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>

<div id="quotationSidebar" class="quotation-sidebar">
    <div class="sidebar-content">
        <div class="d-flex justify-content-between mb-3">
            <h5>Add Quotation Item</h5>
            <button type="button" onclick="closeQuotationSidebar()" class="btn btn-sm btn-danger">X</button>
        </div>

        <form id="quotationForm">
            @csrf

            <input type="hidden" name="project_id" id="quotation_project_id">
            <input type="hidden" name="area_id" id="quotation_area_id">
            <input type="hidden" name="project_item_id" id="project_item_id">

            <!-- Category -->
            <div class="mb-3">
                <label class="form-label">Category</label>
                <select name="category_id" id="categorySelect" class="form-control" required>
                    <option value="">Select Category</option>
                    @foreach(App\Models\Category::all() as $cat)
                    <option value="{{ $cat->id }}">
                        {{ $cat->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <!-- Product -->
            <div class="mb-3">
                <label class="form-label">Product</label>
                <select name="product_id" id="productSelect" class="form-control">
                    <option value="">Select Product</option>
                </select>
            </div>

            <!-- Variant -->
            <div class="mb-3">
                <label class="form-label">Variant</label>
                <select name="variant_id" id="variantSelect" class="form-control">
                    <option value="">Select Variant</option>
                </select>
            </div>

            <!-- Quantity -->
            <div class="mb-3">
                <label class="form-label">Quantity</label>
                <input type="number" name="quantity" class="form-control">
            </div>

            <!-- Dynamic Fields -->
            <div id="dynamicFields"></div>

            <div class="mb-3">
                <label class="form-label">Note</label>
                <textarea name="note" class="form-control"></textarea>
            </div>

            <button type="submit" class="btn btn-success w-100">
                Save
            </button>

        </form>
    </div>
</div>

<script>
  function openQuotationSidebar(item) {

    $('#quotationSidebar').addClass('active');
    $('#quotationForm')[0].reset();

    $('#quotation_project_id').val(item.project_id);
    $('#quotation_area_id').val(item.area_id);
    $('#project_item_id').val(item.id);

    // Auto select category
    $('#categorySelect').val(item.category_id).trigger('change');

}

    function loadVariants(productId, selectedVariant = null) {

        $.ajax({
            url: '/api/project/config/subcategory/2',
            type: 'GET',
            headers: {
                Authorization: 'Bearer YOUR_TOKEN'
            },
            data: {
                product_id: productId,
                variant_id: selectedVariant,
                quantity: 1
            },
            success: function(res) {

                let options = '<option>Select Variant</option>';
                res.data.variants.forEach(function(v) {
                    let selected = (v.id == selectedVariant) ? 'selected' : '';
                    options += `<option value="${v.id}" ${selected}>${v.name}</option>`;
                });

                $('#variantSelect').html(options);
            }
        });
    }

    function closeQuotationSidebar() {
        $('#quotationSidebar').removeClass('active');
    }

  $('#categorySelect').on('change', function () {

    let categoryId = $(this).val();

    if (!categoryId) {
        $('#productSelect').html('<option>Select Product</option>');
        return;
    }

    $.ajax({
        url: "{{ url('project/config/category') }}/" + categoryId,
        type: 'GET',
        success: function (res) {
            let options = '<option value="">Select Product</option>';

            if (res.data && res.data.products) {
                res.data.products.forEach(function (item) {
                    options += `<option value="${item.id}">${item.name}</option>`;
                });
            }

            $('#productSelect').html(options);
        }
    });

});

  $('#productSelect').on('change', function () {

    let productId = $(this).val();

    if (!productId) {
        $('#variantSelect').html('<option>Select Variant</option>');
        return;
    }

    $.ajax({
        url: "{{ url('project/config/subcategory') }}/" + productId,
        type: 'GET',
        success: function (res) {
            let options = '<option value="">Select Variant</option>';

            if (res.data && res.data.variants) {
                res.data.variants.forEach(function (item) {
                    options += `<option value="${item.id}">${item.name}</option>`;
                });
            }

            $('#variantSelect').html(options);
        }
    });

});

 function loadCatalogueSkus(productId) {
    $.ajax({
        url: "{{ url('project/config/catalogue-skus') }}",
        type: 'POST',
        data: { product_id: productId, _token: '{{ csrf_token() }}' },
        success: function(res) {
            console.log(res);
            // populate fields as needed
        }
    });
}
    function loadDynamicFields(category) {

        let html = '';

        if (category == 'curtain') {

            html += `
        <div class="row">
            <div class="col-6">
                <label>Width</label>
                <input type="number" name="measurement[width]" class="form-control">
            </div>
            <div class="col-6">
                <label>Height</label>
                <input type="number" name="measurement[height]" class="form-control">
            </div>
        </div>

        <input type="hidden" name="measurement[measurement_type]" value="curtain">

        <div class="mt-2">
            <label>Unit</label>
            <select name="measurement[unit]" class="form-control">
                <option value="cm">cm</option>
                <option value="in">in</option>
            </select>
        </div>

        <div class="mt-2">
            <label>Motorized</label>
            <select name="details[motorized]" class="form-control">
                <option value="0">No</option>
                <option value="1">Yes</option>
            </select>
        </div>

        <div class="mt-2">
            <label>Motor Control</label>
            <select name="details[motor_control]" class="form-control">
                <option value="left">Left</option>
                <option value="right">Right</option>
            </select>
        </div>

        <div class="mt-2">
            <label>Model</label>
            <input type="text" name="details[model]" class="form-control">
        </div>

        <div class="mt-2">
            <label>Catalogue</label>
            <select name="details[catalogue]" id="catalogueSelect" class="form-control"></select>
        </div>

        <div class="mt-2">
            <label>Serial No</label>
            <input type="text" name="details[serial_no]" class="form-control">
        </div>
        `;
        }

        $('#dynamicFields').html(html);
    }


</script>
@endsection